local assets =
{
	Asset("ANIM", "anim/ast0.zip"),
    Asset("ATLAS", "images/inventoryimages/ast_sr_boards.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ast0")
    inst.AnimState:SetBuild("ast0")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "ast_sr_boards"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ast_sr_boards.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("ast_sr_boards", fn, assets)